#!/bin/bash
# Shared RADS Tools, written by Erik Soroka (eriks@imhadmin.net, ext 834)
# Addition by Vanessa V. 5/12/11
# this script gets executed by crontab to suspend accounts scheduled from RADS tool

FAILED=0

NOW=$(date +%s)

# Pull a list of users
for CURRENTUSER in $(/bin/ls -A /opt/sharedrads/autosuspend)
do
    if [ -z "$CURRENTUSER" ]; then
        echo
        echo "* ERROR: Could not find any accounts pending suspension, exiting."
        echo
        exit 1
    else
        SUSPTIME=$(cat /opt/sharedrads/autosuspend/$CURRENTUSER |awk '{print $1}')

        if [ "$NOW" -ge "$SUSPTIME" ];then
            SUSPREASON=$(cat /opt/sharedrads/autosuspend/$CURRENTUSER |awk '{print $2}')
            TOSUSPEND="$TOSUSPEND $CURRENTUSER"
        fi
    fi
done
unset CURRENTUSER
if [ ! -z "$TOSUSPEND" ];then
    for CURRENTUSER in $TOSUSPEND
    do

        # Check for missing duration or reason
        if [[ -z "$SUSPTIME" ]] || [[ -z "$SUSPREASON" ]]; then
            MSG="cannot determine susp time and/or reason"
            /opt/sharedrads/suspend_user $CURRENTUSER --info --invoked-by "$0" -r '-' -c "$MSG"
            echo "ERROR: Cannot autosuspend $CURRENTUSER - $MSG" | mail -s "[Autosuspend failure] $CURRENTUSER `hostname -s`" reclamations@imhadmin.net
            rm -f /opt/sharedrads/autosuspend/$CURRENTUSER
            exit 1
        fi

        # Check if the user still exists or is already suspended
        VALIDUSER=MAYBE
        /usr/bin/id $CURRENTUSER || VALIDUSER=0

        if [ "$VALIDUSER" = "0" ]; then
            MSG="Cannot process auto-suspension for $CURRENTUSER because they don't appear to exist"
            /opt/sharedrads/suspend_user $CURRENTUSER --info --invoked-by "$0" -r '-' -c "$MSG"
            rm -f /opt/sharedrads/autosuspend/$CURRENTUSER
            exit 1

        elif [ -f /var/cpanel/suspended/$CURRENTUSER ];then
            MSG="Cannot process auto-suspension for $CURRENTUSER because they already appear to be suspended"
            /opt/sharedrads/suspend_user $CURRENTUSER --info --invoked-by "$0" -r '-' -c "$MSG"
            rm -f /opt/sharedrads/autosuspend/$CURRENTUSER
        exit 1
        fi

        # if the reason is a move and the user's domains are pointed here, send an alert
        if echo "$SUSPREASON" | egrep [mM]ove >/dev/null;then
            domainlist=$(egrep ": ${CURRENTUSER}$" /etc/userdomains | cut -d: -f1)
            userFails=()
            for domain in $domainlist
            do
                AREC=$(dig +short $domain |head -1 |awk '{print $1'} )
                MXREC=$(dig +short $(dig +short $domain MX |awk '{print $2}' | tail -1 |awk '{print $1}') |tail -1 )
                if [ ! -z $AREC ];then
                    if grep $AREC /etc/ips >/dev/null || [[ "$AREC" == "$(cat /var/cpanel/mainip)" ]]; then
                        userFails+=( "\n$domain: (A) still pointed to the server" )
                        rm -f /opt/sharedrads/autosuspend/$CURRENTUSER
                        ERROR=1
                    fi
                fi

                if [ ! -z $MXREC ];then
                    if grep $MXREC /etc/ips >/dev/null || [[ "$MXREC" == "$(cat /var/cpanel/mainip |head -1)" ]]; then
                        userFails+=( "\n$domain: (MX) still pointed to the server" )
                        rm -f /opt/sharedrads/autosuspend/$CURRENTUSER
                        ERROR=1
                    fi
                fi
            done
            if [ ${#userFails[@]} -gt 0 ]; then
                echo -e "${userFails[@]}" > /opt/sharedrads/failsuspend/$CURRENTUSER
            fi
        fi

        if [ "$ERROR" != "1" ];then
            MSG="Scheduled suspension for $CURRENTUSER has been initiated"
            /opt/sharedrads/suspend_user $CURRENTUSER -r $SUSPREASON -c "$MSG"
            if [ "$?" -eq 0 ] && [ -f /var/cpanel/suspended/$CURRENTUSER ] ; then
                rm -f /opt/sharedrads/autosuspend/$CURRENTUSER
            fi
        fi
    done
fi
## EOF ##
