import pytest
import ConfigParser
from datetime import datetime, timedelta


@pytest.fixture
def reset():
    def inner(user):
        try:
            sh.Command('unsuspend_user')(user)
        except Exception:
            pass

    return inner


def yaml_data1(file):
    if 'autosuspend.yaml' in file:
        data = {
            'argosy6': {
                'suspensions': [
                    (datetime.now() - timedelta(days=90)).strftime("%s"),
                ],
                'warnings': [
                    (datetime.now() - timedelta(seconds=90)).strftime("%s"),
                ],
            }
        }
        return data
    elif 'sa_interval.yaml' in file:
        return {
            'argosy6': 0.1,
            'ausr': 100,
            'clyde': '8999.1',
            'herrew5': 0.0,
            'baduser': 0.0,
        }


def sa_data1(*x, **y):
    sa_ln = "\n".join(
        [
            "argosy6 3 0.00re 150.00cp 27499k",
            "fooba 6 0.12re 9000.01cp 2799k",
            "clyde 4 0.12re 9000.01cp 2799k",
            "herrew5 4 0.12re 15.00cp 2799k",
            "baduser 4 0.12re 9000.01cp 2799k",
        ]
    )
    return sa_ln


@pytest.fixture
def tmpdir_config(tmpdir):
    conf = tmpdir.mkdir('etc').join('autosuspend.cfg')
    opsdir = tmpdir.mkdir('ops')
    logfile = tmpdir.mkdir('log').join('suspension.log')
    fixture_config = ConfigParser.ConfigParser()
    fixture_config.add_section('settings')
    fixture_config.set('settings', 'opfiles', str(opsdir))
    fixture_config.set('settings', 'suspension_log', str(logfile))
    with open(str(conf), 'w') as fp:
        fixture_config.write(fp)

    return str(conf)
