#! /opt/imh-python/bin/python3

"""
Written by Quintin Holmes
"""

import argparse
import subprocess
import os
import re
# add and remove domains to/from /etc/skiprbldomains
def modify_domains(file_path, domains, action="add"):
    modified = False
    try:
        # read the existing domains
        with open(file_path, "r+") as file:
            existing_domains = set(line.strip() for line in file)
            file.seek(0)  # reset file pointer to the beginning for re-writing if needed
            if action == "add":
                for domain in domains:
                    if domain not in existing_domains:
                        existing_domains.add(domain)
                        modified = True
                # rewrite the file with updated domains
                if modified:
                    file.writelines(f"{domain}\n" for domain in existing_domains)
                    #file.truncate()  # Adjust file size to match new content
            elif action == "remove":
                initial_count = len(existing_domains)
                existing_domains.difference_update(domains)
                if len(existing_domains) < initial_count:  # Check if any domains were removed
                    modified = True
                    print(f"Domains removed from {file_path}.")
                    file.seek(0)
                    file.writelines(f"{domain}\n" for domain in existing_domains)
                    file.truncate()
                else:
                    print(f"No specified domains were found in {file_path}.")
    except PermissionError:
        print(f"Permission denied: Unable to modify {file_path}")
    return modified
#restart Exim
def restart_exim():
    try:
        subprocess.run(["/scripts/buildeximconf"], check=True)
        subprocess.run(["systemctl", "restart", "exim"], check=True)
        print("Exim restarted.")
    except subprocess.CalledProcessError as e:
        print(f"Error restarting Exim: {e}")
# looks for a cp user in userdomains, then adds all domains for the user to skiprbldomains
def find_user_domains(user, userdomains_path="/etc/userdomains"):
    domains = []
    try:
        with open(userdomains_path, "r") as file:
            for line in file:
                domain, owner = line.strip().split(':')
                if owner.strip() == user:
                    domains.append(domain.strip())
    except PermissionError:
        print(f"Permission denied: Unable to read {userdomains_path}")
    return domains
def child_accounts(reseller, file_path):
    accounts = []
    with open('/etc/trueuserowners', 'r') as file:
        for line in file:
            if re.search(f":{reseller}", line):
                accounts.append(line.split(':')[0])
                reseller_domains = []
    for account in accounts:
        with open('/etc/trueuserdomains', 'r') as file:
            for line in file:
                if re.search(f":{account}$", line):
                    reseller_domains.append(line.split(':')[0].strip())
    if reseller_domains:
        modify_domains(file_path, reseller_domains, action="add")
# Main function of the script that has argument setup
def main():
    parser = argparse.ArgumentParser(description="Modify /etc/skiprbldomains file.")
    parser.add_argument("-a", "--add", nargs='+', help="Add domains to the file.", metavar="DOMAIN", default=[], type=str)
    parser.add_argument("-r", "--remove", nargs='+', help="Remove domains from the file.", metavar="DOMAIN", default=[], type=str)
    parser.add_argument("-u", "--user", help="Add all domains owned by this user.", metavar="USERNAME", type=str)
    parser.add_argument("-c", "--child", action="store_true", help="Add reseller child accounts.")
    args = parser.parse_args()
    file_path = "/etc/skiprbldomains"
    domains_added = False
    if not os.path.isfile(file_path):
        try:
            open(file_path, "a").close()
        except PermissionError:
            print(f"Permission denied: Unable to create or modify {file_path}")
            return
    # add and remove actions
    if args.add:
        domains_added = modify_domains(file_path, args.add, action="add")
    if args.remove:
        domains_added = modify_domains(file_path, args.remove, action="remove") or domains_added
    # -- user is used, add their domains
    if args.user:
        user_domains = find_user_domains(args.user)
        if user_domains:
            domains_added = modify_domains(file_path, user_domains, action="add") or domains_added
    if args.child:
        child_accounts(args.user, file_path)
        domains_added = True
    if domains_added:
        restart_exim()
    else:
        print("No changes made.")
if __name__ == "__main__":
    main()
