#!/bin/bash

IFS="
"

right_now=`date +%s`

if [ "$1" != "--api" ]; then
echo
echo "[*] Please wait while I scan /home (this can take a few minutes)..."
echo
fi

if [ "$1" == "--biginodes" ]; then
#lets get a list of directories in public_html with huge inode counts
ls /home/*/public_html -l | egrep -v 'images|attachments|cache' | awk '$1 ~ /^drwx*/ && $5 >50000{print}' | sort -nk5 > /opt/sharedrads/hashscanner/diskspace.check
echo > /opt/sharedrads/hashscanner/hashbiginodedirs.log
exit 0
fi

if [ "$1" == "--oldprofile" ]; then
#we'll be using the old detection method, which we haven't seen in some time
oldprofile=1
else
oldprofile=0
fi

if [ "$1" == "--clean" ]; then
clean=1
else
clean=0
fi

nice -n 19 locate --regex "[0-9a-f]{32}$" | #find all files that end in an md5 hash
sed 's/\/[0-9a-f]*$//' | #if the whole file name is an md5, strip it and the folder's trailing /
uniq -c | #no need to sort, locate does that for us
awk '$1 > 100 {print $2}' | #if there is more than 100 md5s in this folder, it's probably the hack (more checks later)
xargs stat 2>/dev/null | #make sure it still exists
grep "File:" | awk '{print $2}' |
egrep -v 'cache|image|cookies|download_records|wpmp_transcoder|3delight|digita39|nwined5|oracle12|gomojo5|outwor5|bkcrco5|admin/upload|catalog' |
sed -e 's/^.//' -e 's/.$//' > /opt/sharedrads/hashscanner/hashfolders.log #get the folder name from stat's output (only files that exist will have "File:"

if [ $oldprofile -eq 0 ]; then
for i in `cat /opt/sharedrads/hashscanner/hashfolders.log`; # take the list generated above
do dir=$(dirname $i); #get the parent folder path
hashmaker=`nice -n 19 find $dir -maxdepth 1 -iname '*.php' -type f -exec egrep -l "arxefylmiu.ru|ketjxynfpm.ru" '{}' \;;` #grab the php file in the same folder
echo "$hashmaker"
if [ `echo "$hashmaker"|grep -c "php"` -gt 0 -a $clean -gt 0 ]; then
rm -f $hashmaker
find $i -type f -exec rm -f {} \; -exec usleep 20000 \;
rm -rf $i
fi
done  > /opt/sharedrads/hashscanner/hashmakers.log #check size to see if it's in our target range and keep it if it is

accts=`awk -F / '{print $3}' /opt/sharedrads/hashscanner/hashfolders.log | sort | uniq | wc -l`
folders=`wc -l /opt/sharedrads/hashscanner/hashfolders.log|awk '{print $1}'`

else

for i in `cat /opt/sharedrads/hashscanner/hashfolders.log`; # take the list generated above
do dir=$(dirname $i); #get the parent folder path
nice -n 19 chown root.root $i; nice -n 19 chmod 000 $i; #nice chowning
nice -n 19 find $dir -maxdepth 1 -iname '*.php' -type f -exec wc -l '{}' \;; #grab all php files in the same folder and count their lines
done |
awk '$1 == 0 {print $2}' | #if there are no newlines (one indicator)
xargs ls -l | awk '($5 > 25000) && ($5 < 35000) { print $NF }' > /opt/sharedrads/hashscanner/hashmakers.log #check size to see if it's in our target range and keep it if it is

for i in `cat /opt/sharedrads/hashscanner/hashmakers.log | grep home`; do nice -n 19 chown root.root $i; nice -n 19 chmod 000 $i; done #chown the files we found

accts=`awk -F / '{print $3}' /opt/sharedrads/hashscanner/hashfolders.log | sort | uniq | wc -l`
folders=`wc -l /opt/sharedrads/hashscanner/hashfolders.log|awk '{print $1}'`

fi

if [ "$accts" -gt "0" ]; then
peracct=`echo "print $folders.0/$accts.0" | python`
echo
echo "==================== `hostname -s` hashmaker scan/clean ===================="
echo "Accounts affected: $accts"
echo "Folders per account: $peracct"
echo "Total folders: $folders"
echo
echo "List of hashmakers I disabled (set to chmod 0 and root:root):"
echo
cat /opt/sharedrads/hashscanner/hashmakers.log
echo
echo "The related target directories that need careful removal:"
cat /opt/sharedrads/hashscanner/hashfolders.log
echo
fi


if [ "$1" != "--api" ]; then
	if [ "$accts" -lt "1" ]; then
		echo
		echo "[*] Completed.  No hash hacks were found. YAY!"
		echo
	else
		echo
		echo "[*] Completed.  All results are above."
		echo
	fi
fi
