import platform
from pathlib import Path
from tabulate import tabulate
from guds_modules.base import ModuleBase


def run_aux():
    """Show size of common directories and logs"""
    dir_list = [
        '/var/lib/mlocate',
        '/etc/apache2/logs',
        '/etc/apache2/domlogs',
        '/home/moveuser',
        '/var/log/slowqueries',
        f'/var/lib/mysql/{platform.node()}.err',
    ]

    table = []
    headers = ['Path', 'Size']

    for path in dir_list:
        table.append((path, ModuleBase.get_size(Path(path))))

    print(tabulate(table, headers, tablefmt="fancy_grid"))
