#!/bin/bash
PINGTIME="0.9"
if [ -z $1 ];
then
    echo "you must provide a server to check"
    exit;
fi
if [ ! -z $2 ];
then
    PINGTIME=$2
fi;
if (echo $@|grep "\-v"); then
    echo "$@"
    echo "PINGTIME IS $PINGTIME"
    echo "HOST IS $1"
fi
echo "Starting ping test - pinging $1 every $PINGTIME seconds for 100 packets, please be patient..."
echo "You should be running traceroutes from machine A -> machine B and from machine B -> Machine A "
echo "to look for routing issues right now too."
while [ 1 -eq 1 ];
do
    echo $(date) - $(hostname) - $1 - $(ping -c100 -i $PINGTIME $1 |  grep loss) | tee -a $1.pinglog.$(date --iso)
done
