#!/bin/bash

IFS="
"

#DEFINE CUSTOMERS THAT OPTED OUT HERE
EXCLUDES="sandie30 showca10 rdotcl5"


function usage {
        echo "Usage: $0 <--dryrun|--lockdown> <installpath>"
        exit
}

if [ "$1" == "--lockdown" ];
then
lockdown=1
else
if [ "$1" == "--dryrun" ];
then
lockdown=0
else
usage
fi
fi


if [[ -d "$2" ]];
then
cd "$2" #enter the folder

if [[ -d "$PWD/admin" ]]; #if the admin folder exists
then

if [[ -f "$PWD/admin/.htaccess" && `grep "AuthUserFile" "$PWD/admin/.htaccess" | wc -l` > 0 ]]; #if we already have htaccess protection, bail
then
echo "NONEED"
else

user_name="`echo "$2" | cut -d '/' -f 3`" #get the user's name from our path
new_pass=`echo "$user_name" | md5sum | awk '{print $1}' | uuencode -m - | sed -ne 2p | cut -c-16` #generate a new password based on path
new_salt=`cat /proc/meminfo | grep "MemTotal:" | md5sum | awk '{print $1}' | uuencode -m - | sed -ne 2p | cut -c-2` #and salt based on server's installed
memory
new_crypt=`perl -le "print crypt(\"$new_pass\", \"$new_salt\")"` #encrypt the password

ISEXCLUDED=$(echo $EXCLUDES | grep $user_name)

if [ "$ISEXCLUDED" != "" ]; then
echo EXCLUDED
exit 0
fi

if [[ -f "$PWD/includes/configure.php" ]];
then

db_name=`awk -F"'" '/DB_DATABASE/ {print $4}' $PWD/includes/configure.php`
osc_user_name=`mysql -e 'select * from administrators' $db_name|awk '/^1\W/ {print $2}'`
if [ `echo $osc_user_name | wc -c` -lt 2 ]; # we obviously do not have the correct user name
then
osc_user_name=`mysql -e 'select * from admin' $db_name|awk '/^1\W/ {print $2}'` # this is for zen cart
if [ `echo $osc_user_name | wc -c` -lt 2 ]; # we obviously do not have the correct user name
then
osc_user_name=`echo "$user_name"`
fi
fi
else
osc_user_name=`echo "$user_name"`
fi

echo "LOCKED:$osc_user_name:$new_pass" #print the new user/pass combo

#new .htaccess info to append to the file:

if [ $lockdown -eq 1 ];
then

cat >> "$PWD/admin/.htaccess" << EOF
##### ADMIN PROTECTION - BEGIN #####
AuthType Basic
AuthName "Online Merchant Administration Tool"
AuthUserFile "$PWD/admin/.htpasswd_cart"
Require valid-user
##### ADMIN PROTECTION - END #####
EOF

#write the .htpasswd file entry
echo "$osc_user_name:$new_crypt" >> "$PWD/admin/.htpasswd_cart"

chown $user_name.$user_name $PWD/admin/.ht* #chown the files properly

fi #fi lockdown == 1

fi #fi already protected

else
#So there's no admin folder eh?
echo "NOADMIN"
fi
else
echo "DNE"
fi
