#!/bin/bash
# Shared RADS Tools, written by Erik Soroka (eriks@imhadmin.net, ext 834)
# load banner functions

function radsbanner {
echo -e "\033[40;37;2m  INMOTION HOSTING  :  SHARED RADS  :  SHARED RESOURCE ABUSE DETECTION SCRIPTS  \033[0m"
}

function smradsbanner {
echo -e "  \033[40;37;2m.-------------------.\033[0m  "
echo -e "  \033[40;37;2m| INMOTION HOSTING: |\033[0m  "
echo -e "  \033[40;37;2m| SHARED RADS TOOLS |\033[0m  "
echo -e "  \033[40;37;2m\`--------.---------' \033[0m "
echo    "           |           "
echo    "          _|_      -e"
}


function radsbanner-nocolor {
echo "#################################################################################"
echo "  INMOTION HOSTING  .:: SHARED RADS ::.  SHARED RESOURCE ABUSE DETECTION SCRIPTS"
echo "#################################################################################"
}

# Enables log archiving, storing a backup of their current settings if they have them
function archive_logs {
    if [ -f /home/$SUSPENDUSER/.cpanel-logs ]; then
        mkdir -p /home/$SUSPENDUSER/.imh/
        /bin/mv /home/$SUSPENDUSER/.cpanel-logs /home/$SUSPENDUSER/.imh/.cpanel-logs
    fi
    echo "archive-logs=1" > /home/$SUSPENDUSER/.cpanel-logs
    chown $SUSPENDUSER.$SUSPENDUSER /home/$SUSPENDUSER/.cpanel-logs
}

function unarchive_logs {
    if [ -f /home/$SUSPENDUSER/.imh/.cpanel-logs ]; then
        /bin/mv /home/$SUSPENDUSER/.imh/.cpanel-logs /home/$SUSPENDUSER/.cpanel-logs
        chown $SUSPENDUSER.$SUSPENDUSER /home/$SUSPENDUSER/.cpanel-logs
    else
        rm -f /home/$SUSPENDUSER/.cpanel-logs
    fi
}
