#!/opt/imh-python/bin/python3
"""Copyright 2011 Erik Soroka - InMotion Hosting, Inc. - e@inmotion.net - ext 834
This script connects to an SMTP server using smtplib and sends in STRs for autosuspend.sh
"""

# libs and other stuff we need
import sys

from smtplib import SMTP
import datetime

# smtp debug level, raise for more verbosity
debuglevel = 0

# lets make sure we received the necessary arguments

if len(sys.argv) < 2:
    print(
        '\nThis script connects to an SMTP server using python\'s smtplib and sends in'
    )
    print(
        'an STR ticket.  The message body must be passed through a pipe/stdin.\n'
    )
    print("Usage:    cat filename |", sys.argv[0], "<username> <server>\n")
    sys.exit(1)

# setup smtp server info/credentials
smtp = SMTP()
smtp.set_debuglevel(debuglevel)
smtp.connect('mail.imhadmin.net', 25)
smtp.login('lamar@imhadmin.net', 'QMgg-B+W35fL')

# lets set variables based on arguments passed to us
USERNAME = sys.argv[1]
SERVER = sys.argv[2]

# processing notice
print("[*] Connecting to SMTP server...")

# where our mail should come from
from_addr = "IMH T3 Auto Suspend <no-replies@imhadmin.net>"

# assign to addr from powerpanel result
to_addr = "str@imhadmin.net"

# our subject
subj = "AUTO SUSPEND: " + USERNAME + " @ " + SERVER

# fetch the date
date = datetime.datetime.now().strftime("%m/%d/%Y %H:%M")

# get the message from stdin
message_text = sys.stdin.read()
print("[*] Received", len(message_text), "lines from stdin.")

# send it
msg = "From: {}\nTo: {}\nSubject: {}\nDate: {}\n\n{}".format(
    from_addr,
    to_addr,
    subj,
    date,
    message_text,
)
smtp.sendmail(from_addr, to_addr, msg)
smtp.quit()

# echo output
print("[*] STR ticket opened for " + USERNAME + ".\n")

# EOF
