#!/bin/bash
# Shared RADS Tools, written by Erik Soroka (eriks@imhadmin.net, ext 834)
# this script gets executed by crontab to unsuspend temporary suspended accounts from RADS tool

NOW=$(date +%s)

# Pull a list of users to unsuspend
for current_user in $(/bin/ls -A /opt/sharedrads/suspended)
do
    if [ -z "$current_user" ]; then
        echo
        echo "* ERROR: Could not find any accounts pending unsuspension, exiting."
        echo
        exit 1
    else
        unsuspend_time=$(cat /opt/sharedrads/suspended/$current_user |awk '{print $1}')
        suspend_duration=$(cat /opt/sharedrads/suspended/$current_user |awk '{print $2}')

        if [ "$unsuspend_time" == "nontemp" ]; then
            #this is not a temporary suspension, remove from queue and continue
            rm -f /opt/sharedrads/suspended/$current_user
            continue
        elif [ "$NOW" -ge "$unsuspend_time" ]; then
            suspend_reason=$(cat /opt/sharedrads/suspended/$current_user |awk '{print $2}')
            MSG="$suspend_duration suspension for $current_user elapsed"
            /opt/sharedrads/unsuspend_user $current_user --invoked-by "$0" -c "$MSG"
            echo "[`date`] $MSG, account has been [UNSUSPENDED]"
            rm -f /opt/sharedrads/suspended/$current_user
        fi
    fi
done
